/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.geojson;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.measure.Unit;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.geoserver.wfs.json.GeoJSONBuilder;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.RawMap;
import org.geoserver.wms.vector.DeferredFileOutputStreamWebMap;
import org.geoserver.wms.vector.VectorTileBuilder;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.precision.CoordinatePrecisionReducerFilter;
import si.uom.SI;

public class GeoJsonWMSBuilder
implements VectorTileBuilder {
    private Writer writer;
    private CoordinatePrecisionReducerFilter precisionReducerFilter;
    private DeferredFileOutputStream out;
    private GeoJSONBuilder jsonWriter;

    public GeoJsonWMSBuilder(Rectangle mapSize, ReferencedEnvelope mapArea) {
        int memotyBufferThreshold = 8096;
        this.out = DeferredFileOutputStream.builder().setThreshold(8096).setPrefix("geojson").setSuffix(".geojson").get();
        this.writer = new OutputStreamWriter((OutputStream)this.out, StandardCharsets.UTF_8);
        this.jsonWriter = new GeoJSONBuilder(this.writer);
        this.jsonWriter.object();
        this.jsonWriter.key("type").value((Object)"FeatureCollection");
        this.jsonWriter.key("totalFeatures").value((Object)"unknown");
        this.jsonWriter.key("features");
        this.jsonWriter.array();
        CoordinateReferenceSystem mapCrs = mapArea.getCoordinateReferenceSystem();
        this.jsonWriter.setAxisOrder(CRS.getAxisOrder((CoordinateReferenceSystem)mapCrs));
        Unit unit = mapCrs.getCoordinateSystem().getAxis(0).getUnit();
        Unit standardUnit = unit.getSystemUnit();
        PrecisionModel pm = null;
        if (SI.RADIAN.equals(standardUnit)) {
            pm = new PrecisionModel(1000000.0);
        } else if (SI.METRE.equals(standardUnit)) {
            pm = new PrecisionModel(100.0);
        }
        if (pm != null) {
            this.precisionReducerFilter = new CoordinatePrecisionReducerFilter(pm);
        }
    }

    @Override
    public void addFeature(String layerName, String featureId, String geometryName, Geometry aGeom, Map<String, Object> properties) {
        if (this.precisionReducerFilter != null) {
            aGeom.apply((CoordinateSequenceFilter)this.precisionReducerFilter);
        }
        this.jsonWriter.object();
        this.jsonWriter.key("type").value((Object)"Feature");
        this.jsonWriter.key("id").value((Object)featureId);
        this.jsonWriter.key("geometry");
        this.jsonWriter.writeGeom(aGeom);
        this.jsonWriter.key("geometry_name").value((Object)geometryName);
        this.jsonWriter.key("properties");
        this.jsonWriter.object();
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            String attributeName = e.getKey();
            Object value = e.getValue();
            this.jsonWriter.key(attributeName);
            if (value == null) {
                this.jsonWriter.value(null);
                continue;
            }
            this.jsonWriter.value(value);
        }
        this.jsonWriter.endObject();
        this.jsonWriter.endObject();
    }

    public RawMap build(WMSMapContent mapContent) throws IOException {
        RawMap map;
        long length;
        this.jsonWriter.endArray();
        this.jsonWriter.endObject();
        this.writer.flush();
        this.writer.close();
        this.out.close();
        if (this.out.isInMemory()) {
            byte[] data = this.out.getData();
            length = data.length;
            map = new RawMap(mapContent, data, "application/json;type=geojson");
        } else {
            File f = this.out.getFile();
            length = f.length();
            map = new DeferredFileOutputStreamWebMap(mapContent, this.out, "application/json;type=geojson");
        }
        map.setResponseHeader("Content-Length", String.valueOf(length));
        return map;
    }
}

