/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.topojson;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.RawMap;
import org.geoserver.wms.topojson.TopoGeom;
import org.geoserver.wms.topojson.TopoJSONEncoder;
import org.geoserver.wms.topojson.Topology;
import org.geoserver.wms.vector.DeferredFileOutputStreamWebMap;
import org.geoserver.wms.vector.VectorTileBuilder;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.renderer.lite.RendererUtilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;

public class TopologyBuilder
implements VectorTileBuilder {
    private AffineTransform worldToScreen;
    private AffineTransform screenToWorld;
    private List<LineString> arcs = new ArrayList<LineString>();
    private Multimap<String, TopoGeom> layers = ArrayListMultimap.create();
    private GeometryFactory fixedGeometryFactory;

    public TopologyBuilder(Rectangle mapSize, ReferencedEnvelope mapArea) {
        this.worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapArea, (Rectangle)mapSize);
        this.screenToWorld = new AffineTransform(this.worldToScreen);
        try {
            this.screenToWorld.invert();
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
        PrecisionModel precisionModel = new PrecisionModel(10.0);
        this.fixedGeometryFactory = new GeometryFactory(precisionModel);
    }

    @Override
    public void addFeature(String layerName, String featureId, String geometryName, Geometry geometry, Map<String, Object> properties) {
        TopoGeom topoObj;
        try {
            topoObj = this.createObject(featureId, geometry, properties);
        }
        catch (MismatchedDimensionException | TransformException e) {
            throw new RuntimeException(e);
        }
        if (topoObj != null) {
            this.layers.put((Object)layerName, (Object)topoObj);
        }
    }

    public RawMap build(WMSMapContent mapContent) throws IOException {
        HashMap<String, TopoGeom.GeometryColleciton> layers = new HashMap<String, TopoGeom.GeometryColleciton>();
        for (String layer : this.layers.keySet()) {
            Collection collection = this.layers.get((Object)layer);
            TopoGeom.GeometryColleciton layerCollection = new TopoGeom.GeometryColleciton(collection);
            layers.put(layer, layerCollection);
        }
        List<LineString> arcs = this.arcs;
        this.arcs = null;
        this.layers = null;
        Topology topology = new Topology(this.screenToWorld, arcs, layers);
        int threshold = 8096;
        try (DeferredFileOutputStream out = DeferredFileOutputStream.builder().setThreshold(8096).setPrefix("topology").setSuffix(".topojson").get();){
            DeferredFileOutputStreamWebMap deferredFileOutputStreamWebMap;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
                DeferredFileOutputStreamWebMap map;
                long length;
                TopoJSONEncoder encoder = new TopoJSONEncoder();
                encoder.encode(topology, writer);
                ((Writer)writer).flush();
                ((Writer)writer).close();
                if (out.isInMemory()) {
                    byte[] data = out.getData();
                    length = data.length;
                    map = new RawMap(mapContent, data, "application/json;type=topojson");
                } else {
                    File f = out.getFile();
                    length = f.length();
                    map = new DeferredFileOutputStreamWebMap(mapContent, out, "application/json;type=topojson");
                }
                map.setResponseHeader("Content-Length", String.valueOf(length));
                deferredFileOutputStreamWebMap = map;
            }
            return deferredFileOutputStreamWebMap;
        }
    }

    @Nullable
    private TopoGeom createObject(String featureId, Geometry geom, Map<String, Object> properties) throws MismatchedDimensionException, TransformException {
        if ((geom = this.fixedGeometryFactory.createGeometry(geom)).isEmpty()) {
            return null;
        }
        if (geom instanceof GeometryCollection && geom.getNumGeometries() == 1) {
            geom = geom.getGeometryN(0);
        }
        TopoGeom geometry = this.createGeometry(geom);
        geometry.setProperties(properties);
        geometry.setId(featureId);
        return geometry;
    }

    private TopoGeom createGeometry(Geometry geom) {
        TopoGeom topoGeom;
        Preconditions.checkNotNull((Object)geom);
        if (geom instanceof Point) {
            Point point1 = (Point)geom;
            topoGeom = this.createPoint(point1);
        } else if (geom instanceof MultiPoint) {
            MultiPoint point = (MultiPoint)geom;
            topoGeom = this.createMultiPoint(point);
        } else if (geom instanceof LineString) {
            LineString string1 = (LineString)geom;
            topoGeom = this.createLineString(string1);
        } else if (geom instanceof MultiLineString) {
            MultiLineString string = (MultiLineString)geom;
            topoGeom = this.createMultiLineString(string);
        } else if (geom instanceof Polygon) {
            Polygon polygon1 = (Polygon)geom;
            topoGeom = this.createPolygon(polygon1);
        } else if (geom instanceof MultiPolygon) {
            MultiPolygon polygon = (MultiPolygon)geom;
            topoGeom = this.createMultiPolygon(polygon);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geom;
            topoGeom = this.createGeometryCollection(collection);
        } else {
            throw new IllegalArgumentException("Unknown geometry type: " + geom.getGeometryType());
        }
        return topoGeom;
    }

    private TopoGeom.LineString createLineString(LineString geom) {
        int arcIndex = this.arcs.size();
        this.arcs.add(geom);
        return new TopoGeom.LineString((List<Integer>)ImmutableList.of((Object)arcIndex));
    }

    private TopoGeom.Polygon createPolygon(Polygon geom) {
        ArrayList<TopoGeom.LineString> arcs = new ArrayList<TopoGeom.LineString>(1 + geom.getNumInteriorRing());
        arcs.add(this.createLineString((LineString)geom.getExteriorRing()));
        for (int n = 0; n < geom.getNumInteriorRing(); ++n) {
            arcs.add(this.createLineString((LineString)geom.getInteriorRingN(n)));
        }
        return new TopoGeom.Polygon(arcs);
    }

    private TopoGeom.GeometryColleciton createGeometryCollection(GeometryCollection geom) {
        ArrayList<TopoGeom> members = new ArrayList<TopoGeom>(geom.getNumGeometries());
        for (int n = 0; n < geom.getNumGeometries(); ++n) {
            TopoGeom o = this.createGeometry(geom.getGeometryN(n));
            members.add(o);
        }
        TopoGeom.GeometryColleciton collection = new TopoGeom.GeometryColleciton(members);
        return collection;
    }

    private TopoGeom.MultiPolygon createMultiPolygon(MultiPolygon geom) {
        ArrayList<TopoGeom.Polygon> polygons = new ArrayList<TopoGeom.Polygon>(geom.getNumGeometries());
        for (int n = 0; n < geom.getNumGeometries(); ++n) {
            polygons.add(this.createPolygon((Polygon)geom.getGeometryN(n)));
        }
        return new TopoGeom.MultiPolygon(polygons);
    }

    private TopoGeom.MultiLineString createMultiLineString(MultiLineString geom) {
        ArrayList<TopoGeom.LineString> arcs = new ArrayList<TopoGeom.LineString>(geom.getNumGeometries());
        for (int n = 0; n < geom.getNumGeometries(); ++n) {
            arcs.add(this.createLineString((LineString)geom.getGeometryN(n)));
        }
        return new TopoGeom.MultiLineString(arcs);
    }

    private TopoGeom.MultiPoint createMultiPoint(MultiPoint geom) {
        ArrayList<TopoGeom.Point> points = new ArrayList<TopoGeom.Point>(geom.getNumGeometries());
        for (int n = 0; n < geom.getNumGeometries(); ++n) {
            points.add(this.createPoint((Point)geom.getGeometryN(n)));
        }
        return new TopoGeom.MultiPoint(points);
    }

    private TopoGeom.Point createPoint(Point geom) {
        return new TopoGeom.Point(geom.getX(), geom.getY());
    }
}

