/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.vector;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.geoserver.wms.map.StyleQueryUtil;
import org.geoserver.wms.vector.Pipeline;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.util.ScreenMap;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.GeometryClipper;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.LineStringExtracter;
import org.locationtech.jts.geom.util.PointExtracter;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;

public class PipelineBuilder {
    private static final double PIXEL_BASE_SAMPLE_SIZE = 0.25;
    Context context;
    final int clipBBOXSizeIncreasePixels = 12;
    private Pipeline first = Pipeline.END;
    private Pipeline last = Pipeline.END;

    private PipelineBuilder(Context context) {
        this.context = context;
    }

    public static PipelineBuilder newBuilder(ReferencedEnvelope renderingArea, Rectangle paintArea, CoordinateReferenceSystem sourceCrs, double overSampleFactor, int queryBuffer) throws FactoryException {
        Context context = PipelineBuilder.createContext(renderingArea, paintArea, sourceCrs, overSampleFactor, queryBuffer);
        return new PipelineBuilder(context);
    }

    private static Context createContext(ReferencedEnvelope mapArea, Rectangle paintArea, CoordinateReferenceSystem sourceCrs, double overSampleFactor, int queryBuffer) throws FactoryException {
        double[] spans_targetCRS;
        double[] spans_sourceCRS;
        Context context = new Context();
        context.renderingArea = mapArea;
        context.paintArea = paintArea;
        context.sourceCrs = sourceCrs;
        context.worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapArea, (Rectangle)paintArea);
        context.queryBuffer = queryBuffer;
        boolean wrap = false;
        context.projectionHandler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mapArea, (CoordinateReferenceSystem)sourceCrs, (boolean)false);
        CoordinateReferenceSystem mapCrs = context.renderingArea.getCoordinateReferenceSystem();
        context.sourceToTargetCrs = StyleQueryUtil.buildTransform((CoordinateReferenceSystem)sourceCrs, (CoordinateReferenceSystem)mapCrs);
        context.targetToScreen = ProjectiveTransform.create((AffineTransform)context.worldToScreen);
        context.sourceToScreen = ConcatenatedTransform.create((MathTransform)context.sourceToTargetCrs, (MathTransform)context.targetToScreen);
        try {
            spans_sourceCRS = Decimator.computeGeneralizationDistances((MathTransform)context.sourceToScreen.inverse(), (Rectangle)context.paintArea, (double)0.8);
            spans_targetCRS = Decimator.computeGeneralizationDistances((MathTransform)context.targetToScreen.inverse(), (Rectangle)context.paintArea, (double)1.0);
            context.pixelSizeInTargetCRS = Math.max(spans_targetCRS[0], spans_targetCRS[1]);
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
        context.screenSimplificationDistance = 0.25 / overSampleFactor;
        context.sourceCRSSimplificationDistance = Math.min(spans_sourceCRS[0], spans_sourceCRS[1]);
        context.targetCRSSimplificationDistance = Math.min(spans_targetCRS[0], spans_targetCRS[1]) / overSampleFactor;
        context.screenMap = new ScreenMap(0, 0, paintArea.width, paintArea.height);
        context.screenMap.setSpans(spans_sourceCRS[0] / overSampleFactor, spans_sourceCRS[1] / overSampleFactor);
        context.screenMap.setTransform(context.sourceToScreen);
        return context;
    }

    public PipelineBuilder preprocess() {
        this.addLast(new PreProcess(this.context.projectionHandler, this.context.screenMap));
        return this;
    }

    public PipelineBuilder collapseCollections() {
        this.addLast(new CollapseCollections());
        return this;
    }

    public Pipeline build() {
        return this.first;
    }

    private void addLast(Pipeline step) {
        if (this.first == Pipeline.END) {
            this.last = this.first = step;
        } else {
            this.last.setNext(step);
            this.last = step;
        }
    }

    public PipelineBuilder transform(boolean transformToScreenCoordinates) {
        MathTransform sourceToScreen = this.context.sourceToScreen;
        MathTransform sourceToTargetCrs = this.context.sourceToTargetCrs;
        MathTransform tx = transformToScreenCoordinates ? sourceToScreen : sourceToTargetCrs;
        this.addLast(new Transform(tx));
        return this;
    }

    public PipelineBuilder simplify(boolean isTransformToScreenCoordinates, Set<RenderingHints.Key> fsHints, Hints qHints) {
        if (fsHints != null && qHints != null && fsHints.contains(Hints.GEOMETRY_DISTANCE)) {
            qHints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)this.context.sourceCRSSimplificationDistance);
        }
        double pixelDistance = this.context.screenSimplificationDistance;
        double simplificationDistance = this.context.targetCRSSimplificationDistance;
        double distanceTolerance = isTransformToScreenCoordinates ? pixelDistance : simplificationDistance;
        this.addLast(new Simplify(distanceTolerance));
        return this;
    }

    public PipelineBuilder clip(boolean clipToMapBounds, boolean transformToScreenCoordinates) {
        if (clipToMapBounds) {
            ReferencedEnvelope clippingEnvelope;
            if (transformToScreenCoordinates) {
                Rectangle screen = this.context.paintArea;
                Envelope paintArea = new Envelope(0.0, screen.getWidth(), 0.0, screen.getHeight());
                paintArea.expandBy((double)(12 + this.context.queryBuffer));
                clippingEnvelope = paintArea;
            } else {
                ReferencedEnvelope renderingArea = this.context.renderingArea;
                renderingArea.expandBy((double)(12 + this.context.queryBuffer) * this.context.pixelSizeInTargetCRS);
                clippingEnvelope = renderingArea;
            }
            this.addLast(new ClipRemoveDegenerateGeometries((Envelope)clippingEnvelope));
        }
        return this;
    }

    static class Context {
        @Nullable
        ProjectionHandler projectionHandler;
        MathTransform sourceToTargetCrs;
        MathTransform targetToScreen;
        MathTransform sourceToScreen;
        ReferencedEnvelope renderingArea;
        Rectangle paintArea;
        public ScreenMap screenMap;
        public CoordinateReferenceSystem sourceCrs;
        public AffineTransform worldToScreen;
        public double sourceCRSSimplificationDistance;
        public double targetCRSSimplificationDistance;
        public double screenSimplificationDistance;
        public double pixelSizeInTargetCRS;
        public int queryBuffer;

        Context() {
        }
    }

    private static final class PreProcess
    extends Pipeline {
        private final ProjectionHandler projectionHandler;
        private final ScreenMap screenMap;

        PreProcess(@Nullable ProjectionHandler projectionHandler, ScreenMap screenMap) {
            this.projectionHandler = projectionHandler;
            this.screenMap = screenMap;
        }

        @Override
        protected Geometry _run(Geometry geom) throws TransformException, FactoryException {
            Envelope env;
            Geometry preProcessed = geom;
            if (this.projectionHandler != null) {
                preProcessed = this.projectionHandler.preProcess(geom);
            }
            if (preProcessed == null || preProcessed.isEmpty()) {
                return EMPTY;
            }
            if (preProcessed.getDimension() > 0 && this.screenMap.canSimplify(env = preProcessed.getEnvelopeInternal())) {
                if (this.screenMap.checkAndSet(env)) {
                    return EMPTY;
                }
                preProcessed = this.screenMap.getSimplifiedShape(env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY(), preProcessed.getFactory(), preProcessed.getClass());
            }
            return preProcessed;
        }
    }

    private static final class CollapseCollections
    extends Pipeline {
        private CollapseCollections() {
        }

        @Override
        protected Geometry _run(Geometry geom) throws Exception {
            if (geom instanceof GeometryCollection && geom.getNumGeometries() == 1) {
                return geom.getGeometryN(0);
            }
            return geom;
        }
    }

    private static final class Transform
    extends Pipeline {
        private final MathTransform tx;

        Transform(MathTransform tx) {
            this.tx = tx;
        }

        @Override
        protected Geometry _run(Geometry geom) throws Exception {
            Geometry transformed = JTS.transform((Geometry)geom, (MathTransform)this.tx);
            return transformed;
        }
    }

    private static final class Simplify
    extends Pipeline {
        private final double distanceTolerance;

        Simplify(double distanceTolerance) {
            this.distanceTolerance = distanceTolerance;
        }

        @Override
        protected Geometry _run(Geometry geom) throws Exception {
            switch (geom.getDimension()) {
                case 2: {
                    return TopologyPreservingSimplifier.simplify((Geometry)geom, (double)this.distanceTolerance);
                }
                case 1: {
                    return DouglasPeuckerSimplifier.simplify((Geometry)geom, (double)this.distanceTolerance);
                }
            }
            return geom;
        }
    }

    public static final class ClipRemoveDegenerateGeometries
    extends Clip {
        ClipRemoveDegenerateGeometries(Envelope clippingEnvelope) {
            super(clippingEnvelope);
        }

        @Override
        protected Geometry _run(Geometry geom) throws Exception {
            if (geom == null || geom.isEmpty()) {
                return null;
            }
            if (geom.getGeometryType() == "GeometryCollection") {
                return this.collectionClip((GeometryCollection)geom);
            }
            Geometry result = super._run(geom);
            if (result == null || result.isEmpty()) {
                return null;
            }
            if (geom instanceof Point || geom instanceof MultiPoint) {
                return this.onlyPoints(result);
            }
            if (geom instanceof LineString || geom instanceof MultiLineString) {
                return this.onlyLines(result);
            }
            if (geom instanceof Polygon || geom instanceof MultiPolygon) {
                return this.onlyPolygon(result);
            }
            return result;
        }

        private Geometry collectionClip(GeometryCollection geom) throws Exception {
            ArrayList<Geometry> result = new ArrayList<Geometry>();
            for (int t = 0; t < geom.getNumGeometries(); ++t) {
                Geometry g = geom.getGeometryN(0);
                Geometry clipped = this._run(g);
                if (clipped == null || clipped.isEmpty()) continue;
                result.add(clipped);
            }
            if (result.isEmpty()) {
                return null;
            }
            return new GeometryCollection(result.toArray(new Geometry[result.size()]), geom.getFactory());
        }

        private Geometry onlyPolygon(Geometry result) {
            if (result instanceof Polygon || result instanceof MultiPolygon) {
                return result;
            }
            List polys = PolygonExtracter.getPolygons((Geometry)result);
            if (polys.isEmpty()) {
                return null;
            }
            if (polys.size() == 1) {
                return (Geometry)polys.get(0);
            }
            return new MultiPolygon(polys.toArray(new Polygon[polys.size()]), result.getFactory());
        }

        private Geometry onlyLines(Geometry result) {
            if (result instanceof LineString || result instanceof MultiLineString) {
                return result;
            }
            List lines = LineStringExtracter.getLines((Geometry)result);
            if (lines.isEmpty()) {
                return null;
            }
            if (lines.size() == 1) {
                return (Geometry)lines.get(0);
            }
            return new MultiLineString(lines.toArray(new LineString[lines.size()]), result.getFactory());
        }

        private Geometry onlyPoints(Geometry result) {
            if (result instanceof Point || result instanceof MultiPoint) {
                return result;
            }
            List pts = PointExtracter.getPoints((Geometry)result);
            if (pts.isEmpty()) {
                return null;
            }
            if (pts.size() == 1) {
                return (Geometry)pts.get(0);
            }
            return new MultiPoint(pts.toArray(new Point[pts.size()]), result.getFactory());
        }
    }

    protected static class Clip
    extends Pipeline {
        private final Envelope clippingEnvelope;

        Clip(Envelope clippingEnvelope) {
            this.clippingEnvelope = clippingEnvelope;
        }

        @Override
        protected Geometry _run(Geometry geom) throws Exception {
            GeometryClipper clipper = new GeometryClipper(this.clippingEnvelope);
            try {
                return clipper.clip(geom, true);
            }
            catch (Exception e) {
                return clipper.clip(geom, false);
            }
        }
    }
}

