/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.vector;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.LiteFeatureTypeStyle;
import org.geoserver.wms.map.StyleQueryUtil;
import org.geotools.api.data.Query;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.api.style.Rule;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.Filters;
import org.geotools.filter.SortByImpl;
import org.geotools.map.Layer;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

class VectorTileOptions {
    private static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    private final GeometryDescriptor geometryDescriptor;
    private final FeatureType schema;
    List<String> attributes;
    boolean labelLayer;
    List<String> labelAttributes;
    private boolean coalesceEnabled;

    VectorTileOptions(Layer layer, WMSMapContent mapContent) {
        List liteFeatureStyles = StyleQueryUtil.getLiteFeatureStyles((Layer)layer, (WMSMapContent)mapContent);
        for (LiteFeatureTypeStyle lft : liteFeatureStyles) {
            if (lft.options == null) continue;
            this.collectVectorTileOptions(lft.options);
            for (Rule rule : lft.ruleList) {
                this.collectVectorTileOptions(rule.getOptions());
            }
        }
        this.schema = layer.getFeatureSource().getSchema();
        this.geometryDescriptor = this.schema.getGeometryDescriptor();
    }

    private void collectVectorTileOptions(Map<String, String> options) {
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("vt-attributes".equals(key)) {
                this.attributes = this.toStringList(value);
            }
            if ("vt-labels".equals(key)) {
                this.labelLayer = Boolean.valueOf(value);
            }
            if ("vt-label-attributes".equals(key)) {
                this.labelAttributes = this.toStringList(value);
            }
            if (!"vt-coalesce".equals(key)) continue;
            this.coalesceEnabled = Boolean.valueOf(value);
        }
    }

    boolean isPolygonLabelEnabled() {
        Class binding = this.geometryDescriptor.getType().getBinding();
        return Polygon.class.isAssignableFrom(binding) || MultiPolygon.class.isAssignableFrom(binding);
    }

    private List<String> toStringList(String value) {
        return new ArrayList<String>(Arrays.asList(value.split("\\s*,\\s*")));
    }

    List<String> getAttributes() {
        return this.attributes;
    }

    boolean generateLabelLayer() {
        return this.labelLayer;
    }

    List<String> getLabelAttributes() {
        return this.labelAttributes;
    }

    void customizeQuery(Query query) {
        this.customizeQueryAttributes(query, this.attributes);
        if (this.coalesceEnabled) {
            SortBy[] sortBy = query.getSortBy();
            SortBy[] merged = this.getCoalesceSortBy(this.attributes, sortBy);
            query.setSortBy(merged);
        }
    }

    private SortBy[] getCoalesceSortBy(List<String> attributes, SortBy[] sortBy) {
        Set sortAttributes = attributes == null ? (Set)this.schema.getDescriptors().stream().filter(pd -> !(pd instanceof GeometryDescriptor)).map(pd -> FF.property(pd.getName())).collect(Collectors.toCollection(LinkedHashSet::new)) : (Set)attributes.stream().filter(att -> !(this.schema.getDescriptor(att) instanceof GeometryDescriptor)).map(arg_0 -> ((FilterFactory)FF).property(arg_0)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (sortBy != null) {
            for (SortBy sort : sortBy) {
                sortAttributes.remove(sort.getPropertyName());
            }
        }
        Stream<SortBy> attributesSort = sortAttributes.stream().map(p -> new SortByImpl(p, SortOrder.ASCENDING));
        if (sortBy == null) {
            return (SortBy[])attributesSort.toArray(SortBy[]::new);
        }
        return (SortBy[])Streams.concat((Stream[])new Stream[]{Arrays.stream(sortBy), attributesSort}).toArray(SortBy[]::new);
    }

    Query customizeLabelQuery(Query query) {
        if (this.labelAttributes != null) {
            this.customizeQueryAttributes(query, this.labelAttributes);
            Filter nonNullValues = this.getNonNullFilter(this.labelAttributes);
            query.setFilter(Filters.and((FilterFactory)FF, (Filter)query.getFilter(), (Filter)nonNullValues));
        }
        return query;
    }

    private Filter getNonNullFilter(List<String> attributes) {
        if (attributes.size() == 1) {
            return FF.not((Filter)FF.isNull((Expression)FF.property(attributes.get(0))));
        }
        List filters = attributes.stream().map(att -> FF.not((Filter)FF.isNull((Expression)FF.property(att)))).collect(Collectors.toList());
        return FF.and(filters);
    }

    private void customizeQueryAttributes(Query query, List<String> propertyNames) {
        if (propertyNames != null) {
            String defaultGeometry = this.geometryDescriptor.getLocalName();
            if (!propertyNames.contains(defaultGeometry)) {
                propertyNames.add(defaultGeometry);
            }
            query.setPropertyNames(propertyNames);
        }
    }

    boolean isCoalesceEnabled() {
        return this.coalesceEnabled;
    }
}

