/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.geometry;

import java.util.ArrayList;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.graph.build.line.LineStringGraphGenerator;
import org.geotools.graph.path.DijkstraShortestPathFinder;
import org.geotools.graph.path.Path;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.traverse.standard.DijkstraIterator;
import org.geotools.process.geometry.Skeletonize;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;

public class CenterLine {
    public static final GeometryFactory GF = new GeometryFactory();

    public static SimpleFeatureCollection extractCenterLine(SimpleFeatureCollection features, double perc) {
        ArrayList<SimpleFeature> ret = new ArrayList<SimpleFeature>();
        SimpleFeatureType schema = (SimpleFeatureType)features.getSchema();
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName(schema.getName());
        String geomName = schema.getGeometryDescriptor().getLocalName();
        ftb.add(geomName, MultiLineString.class, schema.getCoordinateReferenceSystem());
        ftb.setCRS(schema.getCoordinateReferenceSystem());
        ftb.setDefaultGeometry(geomName);
        for (AttributeDescriptor prop : schema.getAttributeDescriptors()) {
            if (prop.getLocalName().equalsIgnoreCase(geomName)) continue;
            ftb.add(prop);
        }
        SimpleFeatureType outSchema = ftb.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(outSchema);
        try (SimpleFeatureIterator itr = features.features();){
            while (itr.hasNext()) {
                SimpleFeature feature = (SimpleFeature)itr.next();
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                Geometry outGeom = CenterLine.getCenterLine(geom, perc);
                builder.addAll(feature.getAttributes());
                builder.set(geomName, (Object)outGeom);
                SimpleFeature duplicate = builder.buildFeature(feature.getID());
                ret.add(duplicate);
            }
        }
        return DataUtilities.collection(ret);
    }

    public static Geometry getCenterLine(Geometry geom) {
        return CenterLine.getCenterLine(geom, 5.0);
    }

    public static Geometry getCenterLine(Geometry geom, double perc_density) {
        Geometry skel = Skeletonize.getSkeleton(geom, perc_density);
        Geometry outGeom = CenterLine.reduceToCenterLine(skel);
        outGeom = TopologyPreservingSimplifier.simplify((Geometry)outGeom, (double)(outGeom.getLength() * (perc_density / 100.0)));
        outGeom = JTS.smooth((Geometry)outGeom, (double)0.1, (GeometryFactory)GF);
        return outGeom;
    }

    private static Geometry reduceToCenterLine(Geometry geom) {
        LineStringGraphGenerator gen = new LineStringGraphGenerator();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry g = geom.getGeometryN(i);
            if (g.isEmpty()) continue;
            gen.add((Object)g);
        }
        Graph graph = gen.getGraph();
        DijkstraIterator.EdgeWeighter weighter = e -> {
            Geometry g = (Geometry)e.getObject();
            return g.getLength();
        };
        double bestLen = Double.NEGATIVE_INFINITY;
        Path bestPath = null;
        List ends = graph.getNodesOfDegree(1);
        for (int i = 0; i < ends.size(); ++i) {
            Node source = (Node)ends.get(i);
            DijkstraShortestPathFinder dspf = new DijkstraShortestPathFinder(graph, (Graphable)source, weighter);
            dspf.calculate();
            for (int j = i + 1; j < ends.size(); ++j) {
                Node dest = (Node)ends.get(j);
                double len = 0.0;
                Path path = dspf.getPath((Graphable)dest);
                if (path == null) continue;
                for (Edge e2 : path.getEdges()) {
                    Geometry g = (Geometry)e2.getObject();
                    len += g.getLength();
                }
                if (!(len > bestLen)) continue;
                bestPath = path;
                bestLen = len;
            }
        }
        ArrayList<LineString> edges = new ArrayList<LineString>();
        for (Edge e3 : bestPath.getEdges()) {
            Geometry g = (Geometry)e3.getObject();
            edges.add((LineString)g);
        }
        return GF.createMultiLineString(GeometryFactory.toLineStringArray(edges));
    }
}

