/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.geometry;

import java.util.logging.Logger;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.factory.StaticMethodsProcessFactory;
import org.geotools.process.geometry.CenterLine;
import org.geotools.text.Text;
import org.locationtech.jts.geom.Geometry;

public class CenterLineProcess
extends StaticMethodsProcessFactory<CenterLineProcess> {
    private static final Logger LOG = Logger.getLogger("org.geotools.process.geometry.CenterLineProcess");

    public CenterLineProcess() {
        super(Text.text((String)"geo"), "centerLine", CenterLineProcess.class);
    }

    @DescribeProcess(title="Center Line", description="Extract Center Line of a Polygon")
    @DescribeResult(description="A geometry that is the longest center line (skeleton) of the input polygon")
    public static Geometry centerLine(@DescribeParameter(name="geometry", description="The Geometry to extract the center line from", min=1, max=1) Geometry geometry, @DescribeParameter(name="tolerance", description="%age of perimeter to use for densification/simplification of input/output. Optional, default is 5.0", min=0, max=1, minValue=1.0, maxValue=100.0) Double tolerance) {
        LOG.fine("got " + String.valueOf(geometry.getClass()));
        double tol = tolerance == null ? 5.0 : tolerance;
        Geometry ret = CenterLine.getCenterLine(geometry, tol);
        LOG.fine("Returning " + String.valueOf(ret.getClass()));
        return ret;
    }
}

