/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.vector.iterator;

import java.util.Map;
import java.util.TreeMap;
import org.geoserver.wms.vector.iterator.VTFeature;
import org.geoserver.wms.vector.iterator.VTIterator;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.GeometryAttribute;
import org.geotools.api.feature.Property;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Geometry;

class ComplexVTIterator
implements VTIterator {
    FeatureIterator<?> delegate;

    public ComplexVTIterator(FeatureIterator<?> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public VTFeature next() {
        Feature f = this.delegate.next();
        return new VTFeature(String.valueOf(f.getIdentifier()), (Geometry)f.getDefaultGeometryProperty().getValue(), this.getProperties((ComplexAttribute)f));
    }

    private Map<String, Object> getProperties(ComplexAttribute feature) {
        TreeMap<String, Object> props = new TreeMap<String, Object>();
        for (Property p : feature.getProperties()) {
            Map<String, Object> value;
            if (!(p instanceof Attribute) || p instanceof GeometryAttribute) continue;
            String name = p.getName().getLocalPart();
            if (p instanceof ComplexAttribute) {
                ComplexAttribute attribute = (ComplexAttribute)p;
                value = this.getProperties(attribute);
            } else {
                value = p.getValue();
            }
            if (value == null) continue;
            props.put(name, value);
        }
        return props;
    }
}

