/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.geometry;

import org.geotools.geometry.jts.GeometryBuilder;
import org.locationtech.jts.algorithm.construct.MaximumInscribedCircle;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class PolyLabeller {
    private static final double DISTANCE_TOLERANCE_PERC = 0.8;
    static GeometryBuilder GB = new GeometryBuilder();

    static Point getPolylabel(Geometry geometry, Double precision) {
        if (geometry == null) {
            return null;
        }
        if (geometry.isEmpty() || geometry.getArea() <= 0.0) {
            return null;
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            return PolyLabeller.getPolyLabel_(polygon, precision).getPosition();
        }
        if (geometry instanceof MultiPolygon) {
            LabelPosition widest = null;
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                Polygon p = (Polygon)geometry.getGeometryN(i);
                LabelPosition polylabel = PolyLabeller.getPolyLabel_(p, precision);
                if (widest != null && !(polylabel.getDistance() > widest.getDistance())) continue;
                widest = polylabel;
            }
            return widest.getPosition();
        }
        throw new IllegalStateException("Input polygon must be a Polygon or MultiPolygon");
    }

    private static LabelPosition getPolyLabel_(Polygon polygon, Double precision) {
        if (precision == null) {
            precision = PolyLabeller.getDefaultPrecision((Geometry)polygon);
        }
        Point polyLabel = MaximumInscribedCircle.getCenter((Geometry)polygon, (double)precision);
        Point centroid = polygon.getCentroid();
        Point envelopeCenter = polygon.getEnvelope().getCentroid();
        Geometry boundary = polygon.getBoundary();
        double distancePolyLabel = polyLabel.distance(boundary);
        double distanceCentroid = centroid.distance(boundary);
        double distanceEnvelope = envelopeCenter.distance(boundary);
        if (distanceCentroid > distancePolyLabel * 0.8 && polygon.contains((Geometry)centroid)) {
            return new LabelPosition(centroid, distanceCentroid);
        }
        if (distanceEnvelope > distancePolyLabel * 0.8 && polygon.contains((Geometry)envelopeCenter)) {
            return new LabelPosition(envelopeCenter, distanceEnvelope);
        }
        return new LabelPosition(polyLabel, distancePolyLabel);
    }

    private static double getDefaultPrecision(Geometry polygon) {
        return Math.sqrt(polygon.getArea()) / Math.PI / 2.0;
    }

    private static class LabelPosition {
        Point position;
        double distance;

        public LabelPosition(Point position, double distance) {
            this.position = position;
            this.distance = distance;
        }

        public Point getPosition() {
            return this.position;
        }

        public double getDistance() {
            return this.distance;
        }
    }
}

