/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.geometry;

import java.util.logging.Logger;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.factory.StaticMethodsProcessFactory;
import org.geotools.process.geometry.Skeletonize;
import org.geotools.text.Text;
import org.locationtech.jts.geom.Geometry;

public class SkeletonizeProcess
extends StaticMethodsProcessFactory<SkeletonizeProcess> {
    private static final Logger LOG = Logger.getLogger("org.geotools.process.geometry.SkeletonizeProcess");

    public SkeletonizeProcess() {
        super(Text.text((String)"geo"), "skeltonize", SkeletonizeProcess.class);
    }

    @DescribeProcess(title="Skeletonize", description="Create the full skeleton line of a Polygon")
    @DescribeResult(description="A geometry that is the center line (skeleton) of the input polygon")
    public static Geometry centerLine(@DescribeParameter(name="geometry", description="The Geometry to extract the center line from", min=1, max=1) Geometry geometry, @DescribeParameter(name="tolerance", description="%age of perimeter to use for densification/simplification of input/output. Optional, default is 5.0", min=0, max=1, minValue=1.0, maxValue=100.0) Double tolerance) {
        LOG.fine("got " + String.valueOf(geometry.getClass()));
        double tol = tolerance == null ? 5.0 : tolerance;
        Geometry ret = Skeletonize.getSkeleton(geometry, tol);
        LOG.fine("Returning " + String.valueOf(ret.getClass()));
        return ret;
    }
}

